; ******************************************************
;           DC mBOT - Main Settings
; ******************************************************
alias DC-mBOT { dialog $iif(!$dialog(DC-mBOT),-m,-v) DC-mBOT DC-mBOT }

dialog DC-mBOT {
  title "DC mBOT Main Settings [F1]"
  size -1 -1 160 178
  option dbu
  icon $DC.Imgs(Set.ico)
  button "&Help", 33, 73 165 40 10
  button "&Done", 28, 115 165 40 10, default
  box "", 1, 7 46 146 113
  tab "General", 3, 3 31 154 131
  check "Enable DC mBOT", 2, 13 62 52 10, tab 3
  edit "", 30, 58 81 70 10, tab 3 autohs
  edit "", 118, 58 99 70 10, tab 3 autohs
  text "Co-Owners:", 117, 15 100 40 8, tab 3 right
  text "Owner:", 29, 15 82 40 8, tab 3 right
  text "Note: You can add certain Co-Owners separating by comma. One more note is: The Bot Nickname, Password and Auto identify has been removed from here, You can manage them from 'Connection Manager' dialog for each of your connections.", 19, 12 118 134 37, tab 3
  tab "Original Cmds", 8
  list 5, 11 54 100 99, tab 8 size check
  link "Enable All", 6, 115 132 25 8, tab 8
  link "Disable All", 7, 115 143 29 8, tab 8
  tab "Custom Cmds", 4
  list 13, 11 54 100 99, tab 4 size check disable
  button "Add", 14, 113 56 37 10, tab 4 disable
  button "Edit", 15, 113 67 37 10, tab 4 disable
  button "Remove", 16, 113 78 37 10, tab 4 disable
  link "Enable All", 17, 115 132 28 8, tab 4 disable
  link "Disable All", 18, 115 143 32 8, tab 4 disable
  tab "Masters", 9
  text "Enter Password:", 106, 89 83 42 9, tab 9
  edit "", 104, 89 94 61 10, tab 9 autohs
  edit "", 24, 89 69 60 10, tab 9 autohs
  text "Enter Nickname:", 105, 89 58 42 9, tab 9
  list 23, 11 54 75 101, tab 9 size vsbar
  button "&Add", 25, 89 107 30 10, tab 9
  button "&Remove", 26, 120 107 30 10, tab 9
  button "&Clear List", 27, 89 144 61 10, tab 9
  tab "Other", 10
  check "Use Custom Trigger:", 101, 12 55 57 10, tab 10
  edit "", 102, 71 55 15 10, tab 10 limit 1 center
  combo 38, 47 97 67 65, tab 10 size drop
  text "Bot Bantype:", 39, 12 98 33 9, tab 10
  text "wrong Login/Pass cmd for", 112, 53 144 64 8, tab 10 center
  edit "", 113, 117 143 18 10, tab 10 limit 3 center
  text "Mins", 114, 137 144 13 8, tab 10
  check "Ignore User", 110, 12 129 42 10, tab 10
  check "Use Notice Commands", 116, 12 76 69 10, tab 10
  edit "", 111, 39 143 13 10, tab 10 limit 1 center
  text "When Sent", 12, 9 144 29 8, tab 10
  box "Security", 11, 7 118 146 41, tab 10
  list 20, -6 -1 173 30, size
  list 21, 4 4 25 25, size
  text "Main Settings", 22, 29 3 136 15
  text "This is the primary mBOT settings...", 31, 30 17 135 10
}

on *:dialog:DC-mBOT:*:*:{
  if ($devent == init) {
    hOS EnableCloseBox $dialog(DC-mBOT).hwnd false
    MDX MarkDialog $dname
    MDX SetMircVersion $version
    MDX SetBorderStyle $dname 20,21 simple
    MDX SetControlMDX $dname 21 Toolbar flat nodivider wrap list arrows > $Bars
    MDX SetColor $dname 20,21,22,31 background $rgb(199,199,199)
    MDX SetColor $dname 20,21,22,31 textbg $rgb(199,199,199)
    MDX SetColor $dname 20,22 text $rgb(65,141,255)
    MDX SetColor $dname 31 text $rgb(0,0,0)
    MDX SetFont $dname 22 +a 25 700 Ringbearer
    MDX SetFont $dname 31 +a 14 700 Arial
    did -i $dname 21 1 bmpsize 32 32
    did -i $dname 21 1 setimage icon normal $noqt($DC.Imgs(Set.ico))
    did -a $dname 21 +a 1 $chr(9) $+ Main Settings
    did -b $dname 20,21
    if (%Enable.DC.mBOT == ON) { did -c $dname 2 }
    if (!%Trigger) { set %Trigger $chr(33) | set %DC-mBOT-Custom-Trigger OFF }
    if (%Trigger == $chr(33)) { set %DC-mBOT-Custom-Trigger OFF }
    else { set %DC-mBOT-Custom-Trigger ON }
    did -a DC-mBOT 5 %Trigger $+ Op <Nick>
    did -a DC-mBOT 5 %Trigger $+ Voice <Nick>
    did -a DC-mBOT 5 %Trigger $+ Ban <Nick|Host>
    did -a DC-mBOT 5 %Trigger $+ Deop <Nick>
    did -a DC-mBOT 5 %Trigger $+ Devoice <Nick>
    did -a DC-mBOT 5 %Trigger $+ Unban <Nick|Host>
    did -a DC-mBOT 5 %Trigger $+ Kick <Nick|Host>
    did -a DC-mBOT 5 %Trigger $+ Kick Ban <Nick|Host>
    did -a DC-mBOT 5 %Trigger $+ Mode <Mode>
    did -a DC-mBOT 5 %Trigger $+ Topic [Channel] <Message>
    did -a DC-mBOT 5 %Trigger $+ Invite <Nick>
    did -a DC-mBOT 5 %Trigger $+ Slap <Nick>
    did -a DC-mBOT 5 %Trigger $+ Say <Message>
    did -a DC-mBOT 5 %Trigger $+ Act <Message>
    did -a DC-mBOT 5 %Trigger $+ Fsh <On|Off>
    did -a DC-mBOT 5 %Trigger $+ Btype <1-10>
    did -a DC-mBOT 5 %Trigger $+ Pro [Section] <On|Off>
    did -a DC-mBOT 5 %Trigger $+ Extra [Section] <On|Off>
    did -a DC-mBOT 5 %Trigger $+ Nick <NewNick>
    did -a DC-mBOT 5 %Trigger $+ Identify <Password>
    did -a DC-mBOT 5 %Trigger $+ Join <Channel>
    did -a DC-mBOT 5 %Trigger $+ Part <Channel>
    did -a DC-mBOT 5 %Trigger $+ Bot <On|Off>
    did -a DC-mBOT 5 %Trigger $+ Quit <Message>
    did -a DC-mBOT 5 %Trigger $+ Help <Section>
    did -a DC-mBOT 5 %Trigger $+ Amaster & %Trigger $+ Dmaster <Nick>
    did -a DC-mBOT 5 %Trigger $+ ChanStat [Channel]
    if (!%DC-mBOT-UIgnore-Cmd) { set %DC-mBOT-UIgnore-Cmd ON | set %DC-mBOT-UIgnore.Times 3 | set %DC-mBOT-UIgnore.Ban 60 }
    if (%DC-mBOT-Op-Cmd == ON) did -s $dname 5 1
    if (%DC-mBOT-Voice-Cmd == ON) did -s $dname 5 2
    if (%DC-mBOT-Ban-Cmd == ON) did -s $dname 5 3
    if (%DC-mBOT-DeOp-Cmd == ON) did -s $dname 5 4
    if (%DC-mBOT-DeVoice-Cmd == ON) did -s $dname 5 5
    if (%DC-mBOT-UnBan-Cmd == ON) did -s $dname 5 6
    if (%DC-mBOT-Kick-Cmd == ON) did -s $dname 5 7
    if (%DC-mBOT-Kb-Cmd == ON) did -s $dname 5 8
    if (%DC-mBOT-Mode-Cmd == ON) did -s $dname 5 9
    if (%DC-mBOT-Topic-Cmd == ON) did -s $dname 5 10
    if (%DC-mBOT-Invite-Cmd == ON) did -s $dname 5 11
    if (%DC-mBOT-Slap-Cmd == ON) did -s $dname 5 12
    if (%DC-mBOT-Say-Cmd == ON) did -s $dname 5 13
    if (%DC-mBOT-Act-Cmd == ON) did -s $dname 5 14
    if (%DC-mBOT-Fsh-Cmd == ON) did -s $dname 5 15
    if (%DC-mBOT-BanType-Cmd == ON) did -s $dname 5 16
    if (%DC-mBOT-Pro-Cmd == ON) did -s $dname 5 17
    if (%DC-mBOT-Extra-Cmd == ON) did -s $dname 5 18
    if (%DC-mBOT-Nick-Cmd == ON) did -s $dname 5 19
    if (%DC-mBOT-Identify-Cmd == ON) did -s $dname 5 20
    if (%DC-mBOT-Join-Cmd == ON) did -s $dname 5 21
    if (%DC-mBOT-Part-Cmd == ON) did -s $dname 5 22
    if (%DC-mBOT-BotOff-Cmd == ON) did -s $dname 5 23
    if (%DC-mBOT-Quit-Cmd == ON) did -s $dname 5 24
    if (%DC-mBOT-Help-Cmd == ON) did -s $dname 5 25
    if (%DC-mBOT-Admaster-Cmd == ON) did -s $dname 5 26
    if (%DC-mBOT-ChanStat-Cmd == ON) did -s $dname 5 27
    if (%DC-mBOT-UIgnore-Cmd == ON) did -c $dname 110
    if (%Notice.Cmds == ON) did -c $dname 116
    if (%DC-mBOT-UIgnore-Cmd == OFF) { did -b $dname 111,113 }
    if (%DC-mBOT-Custom-Trigger == ON) did -c $dname 101
    if (%DC-mBOT-Custom-Trigger == OFF) did -b $dname 102
    if (!%Bot-BanTypes) { set %Bot-BanTypes 2 }
    didtok DC-mBOT 38 32 *!User@Host *!*User@Host *!*@Host *!*User@*.Host *!*@*.Host Nick!User@Host Nick!*User@Host Nick!*@Host Nick!*User@*.Host Nick!*@*.Host
    did -c DC-mBOT 38 $calc(%Bot-BanTypes + 1)
    mBOT-Master-List
    Load.CCmd
    if (%Owner-DC.mBOT == NotSet) { unset %Owner-DC.mBOT }
    if (%Co.Owner-DC.mBOT == NotSet) { unset %Co.Owner-DC.mBOT }
    did -a $dname 30 %Owner-DC.mBOT
    did -a $dname 102 %Trigger
    did -a $dname 111 %DC-mBOT-UIgnore.Times
    did -a $dname 113 %DC-mBOT-UIgnore.Ban
    did -a $dname 118 %Co.Owner-DC.mBOT
    did -b $dname 25,26
  }
  if ($devent == edit) {
    if ($did == 24) || ($did == 104) {
      if (!$did(24)) || (!$did(104)) { did -b $dname 25 }
      else { did -e $dname 25 }
    }
    if ($did == 30) { set %Owner-DC.mBOT $did(30) }
    if ($did == 118) { set %Co.Owner-DC.mBOT $did(118) }
    if ($did == 102) {
      if (!$did(102)) { set %Trigger $chr(33) }
      else { set %Trigger $did(102) }
    }
    if ($did == 111) { set %DC-mBOT-UIgnore.Times $did(111) }
    if ($did == 113) { set %DC-mBOT-UIgnore.Ban $did(113) }
  }
  if ($devent == close) {
    if (!$did(111) || !$did(113)) { set %DC-mBOT-UIgnore-Cmd OFF }
  }
  if ($devent == sclick) {
    if ($did == 2) {
      if (%Enable.DC.mBOT == ON) { set %Enable.DC.mBOT OFF | .disable #DC-mBOT }
      else { set %Enable.DC.mBOT ON | .enable #DC-mBOT }
    }
    if ($did == 6) || ($did == 7) { mB.Checkmark o $iif($did == 6,-s,-l) }
    if ($did == 14) { AddCommand }
    if ($did == 15 || $did == 16) && ($did(13).seltext) { $iif($did == 15,EditCommand,DelCommand) $did(13).seltext }
    if ($did == 17) || ($did == 18) { mB.Checkmark c $iif($did == 17, -s, -l) }
    if ($did == 23) && ($did(23).sel) { did -e $dname 26 }
    if ($did == 101) {
      if (%DC-mBOT-Custom-Trigger == ON) { set %DC-mBOT-Custom-Trigger OFF | did -b $dname 102 | set %Trigger ! | did -ra $dname 102 %Trigger }
      else { set %DC-mBOT-Custom-Trigger ON | did -e $dname 102 }
    }
    if ($did == 110) {
      if (%DC-mBOT-UIgnore-Cmd == ON) { set %DC-mBOT-UIgnore-Cmd OFF | did -b $dname 111,113 }
      else { set %DC-mBOT-UIgnore-Cmd ON | did -e $dname 111,113 }
    }
    if ($did == 116) { 
      if (%Notice.Cmds == ON) { set %Notice.Cmds OFF | unset %Notice.Pass }
      else { dialog $iif(!$dialog(Notice.Cmds),-ma,-va) Notice.Cmds Notice.Cmds }
    }
    if ($did == 25) {
      if (* * iswm $did(24)) { dialog -c DC-mBOT | .echo -aq $input(Don't Leave Empty Character!,i8o,Error In DC mBOT Dialog!) | dialog -ma DC-mBOT DC-mBOT }
      else { set %TmpPass $did(104) | set -u5 %DialogAdd ON | Master-Add $did(24) }
    }
    if ($did == 26) && ($did(23).sel) { set %Bot-Master-Del $did(23).seltext | set -u5 %DialogAdd ON | Master-Del }
    if ($did == 27) {
      if ($didtok(23,1) == $null) { .echo -aq $input(There is nothing to clear!,oi8vg,List is already clear) }
      else {
        set -u5 %Result $input(Are you sure? $+ $crlf $+ You want to clear all the Masters from list?,qyvg,Clear Masters List)
        if (%Result == $yes) { .write -c $DC.Dir(mBOT\Masters.ini) | mBOT-Master-List }
        if (%Result == $no) { halt }
      }
    }
    if ($did == 33) { set %HFile Help | Run_Help }
    if ($did == 38) { set %Bot-BanTypes $calc($did(38).sel - 1) }
    if ($did == 28) { 
      if (%Enable.DC.mBOT == ON) && (!$did(30)) { .echo -aq $input(DC mBOT is enabled! You must set the Owner Nickname!,i8o,Error!) | DC-mBOT | return }
      else { set %Owner-DC.mBOT $remove($did(30),$chr(32)) }
      set %Co.Owner-DC.mBOT $remove($did(118),$chr(32))
      Changes.Cmds
      dialog -c DC-mBOT
    }
  }
}

dialog -l Notice.Cmds {
  title "Cmds By Notice"
  size -1 -1 130 87
  option dbu
  icon $DC.Imgs(MB.ico)
  box "", 1, 2 0 126 72
  text "By this option you can send Commands via notice. It needs a Password for authorization and you must type it with your Commands.", 2, 7 6 118 20
  text "Ex.: /notice mBOT PASS mode #Chan +v Nick", 3, 7 30 118 10
  text "Well, press Yes to Enable it and set a Password or click NO to cancel it.", 4, 7 41 118 16
  text "Attention! DO NOT USE SPACE IN PASSWORD", 5, 7 60 118 10
  button "&Yes", 6, 92 75 35 10, flat
  button "&No", 7, 53 75 35 10, flat
}
on *:dialog:Notice.Cmds:*:*:{
  if ($devent == init) { hOS EnableCloseBox $dialog(Notice.Cmds).hwnd false }
  if ($devent == sclick) {
    if ($did == 6) {
      set %Notice.Pass $$?"Enter The Password Here"
      if (%Notice.Pass != $null) { set %Notice.Cmds ON }
      dialog -x Notice.Cmds
      if ($dialog(DC-mBOT)) { did -c DC-mBOT 116 }
    }
    if ($did == 7) {
      set %Notice.Cmds OFF
      dialog -x Notice.Cmds
      if ($dialog(DC-mBOT)) { did -u DC-mBOT 116 }
    }
  }
}
alias -l Changes.Cmds {
  set %DC-mBOT-Op-Cmd $iif($did(DC-mBOT,5,1).cstate == 0,OFF,ON)
  set %DC-mBOT-Voice-Cmd $iif($did(DC-mBOT,5,2).cstate == 0,OFF,ON)
  set %DC-mBOT-Ban-Cmd $iif($did(DC-mBOT,5,3).cstate == 0,OFF,ON)
  set %DC-mBOT-DeOp-Cmd $iif($did(DC-mBOT,5,4).cstate == 0,OFF,ON)
  set %DC-mBOT-DeVoice-Cmd $iif($did(DC-mBOT,5,5).cstate == 0,OFF,ON)
  set %DC-mBOT-UnBan-Cmd $iif($did(DC-mBOT,5,6).cstate == 0,OFF,ON)
  set %DC-mBOT-Kick-Cmd $iif($did(DC-mBOT,5,7).cstate == 0,OFF,ON)
  set %DC-mBOT-Kb-Cmd $iif($did(DC-mBOT,5,8).cstate == 0,OFF,ON)
  set %DC-mBOT-Mode-Cmd $iif($did(DC-mBOT,5,9).cstate == 0,OFF,ON)
  set %DC-mBOT-Topic-Cmd $iif($did(DC-mBOT,5,10).cstate == 0,OFF,ON)
  set %DC-mBOT-Invite-Cmd $iif($did(DC-mBOT,5,11).cstate == 0,OFF,ON)
  set %DC-mBOT-Slap-Cmd $iif($did(DC-mBOT,5,12).cstate == 0,OFF,ON)
  set %DC-mBOT-Say-Cmd $iif($did(DC-mBOT,5,13).cstate == 0,OFF,ON)
  set %DC-mBOT-Act-Cmd $iif($did(DC-mBOT,5,14).cstate == 0,OFF,ON)
  set %DC-mBOT-Fsh-Cmd $iif($did(DC-mBOT,5,15).cstate == 0,OFF,ON)
  set %DC-mBOT-BanType-Cmd $iif($did(DC-mBOT,5,16).cstate == 0,OFF,ON)
  set %DC-mBOT-Pro-Cmd $iif($did(DC-mBOT,5,17).cstate == 0,OFF,ON)
  set %DC-mBOT-Extra-Cmd $iif($did(DC-mBOT,5,18).cstate == 0,OFF,ON)
  set %DC-mBOT-Nick-Cmd $iif($did(DC-mBOT,5,19).cstate == 0,OFF,ON)
  set %DC-mBOT-Identify-Cmd $iif($did(DC-mBOT,5,20).cstate == 0,OFF,ON)
  set %DC-mBOT-Join-Cmd $iif($did(DC-mBOT,5,21).cstate == 0,OFF,ON)
  set %DC-mBOT-Part-Cmd $iif($did(DC-mBOT,5,22).cstate == 0,OFF,ON)
  set %DC-mBOT-BotOff-Cmd $iif($did(DC-mBOT,5,23).cstate == 0,OFF,ON)
  set %DC-mBOT-Quit-Cmd $iif($did(DC-mBOT,5,24).cstate == 0,OFF,ON)
  set %DC-mBOT-Help-Cmd $iif($did(DC-mBOT,5,25).cstate == 0,OFF,ON)
  set %DC-mBOT-Admaster-Cmd $iif($did(DC-mBOT,5,26).cstate == 0,OFF,ON)
  set %DC-mBOT-ChanStat-Cmd $iif($did(DC-mBOT,5,27).cstate == 0,OFF,ON)
}

alias -l mB.Checkmark {
  if ($1) && ($2) {
    var %x = 1
    while (%x < $calc($did(DC-mBOT,$iif($1 == o,5,13)).lines + 1)) { did $2 DC-mBOT $iif($1 == o,5,13) %x | inc %x }
  }
}

alias mBOT-Master-List {
  did -r DC-mBOT 23,24,104
  var %c = 0
  while (%c <= $lines($DC.Dir(mBOT\Masters.ini))) {
    var %x = $read($DC.Dir(mBOT\Masters.ini),%c)
    if (*Master_* iswm %x) { did -a DC-mBOT 23 $right($left(%x,-1),-8) }
    inc %c
  }
  did -b DC-mBOT 25,26
}

alias _SetMode { mode $1 $replace($2,-,+,+,-) $3- }
alias Cown-Check {
  if ($istok(%Co.Owner-DC.mBOT,$1,44)) return $true
  return $false
}

#DC-mBOT on
on *:Text:*:#:{
  if (%Enable.DC.mBOT == OFF) goto end
  if (%Enable.DC.mBOT == ON) {
    set -u6 %Do-Nick $nick
    if ($1 == %Trigger $+ ip) && (%IP-Loc-Cmd == ON) {
      if (%Extra-Set == OFF) goto end
      else {
        if (!$sock(locate)) { set %IP-Chan $chan | locate $2 | goto end }
        else { msg $chan IP Locator is currently busy... | goto end }
      }
    }
    if ($1 == %Trigger $+ chanstat) && (%DC-mBOT-ChanStat-Cmd == ON) {
      if (%Extra-Set == OFF) goto end
      if (!$2) { set %Go.Stats.Chan $chan | set %Go.Stats.Chans $chan | Say-Chan-Stats %Go.Stats.Chans | goto end }
      else { set %Go.Stats.Chan $chan | set %Go.Stats.Chans $2 | Say-Chan-Stats %Go.Stats.Chans | goto end }
    }
    if ($1 == %Trigger $+ slap) && (%DC-mBOT-Slap-Cmd == ON) { 
      if (!$2) { .notice $nick You must enter a Nickname! | goto end }
      if ($2 == $me) { describe $chan Slaps $nick around a bit with a large trout! Haha! | goto end }
      else { describe $chan Slaps $2 around a bit with a large trout! | goto end }
    }
    var %LL = $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %Do-Nick,Login)
    var %LX = $readini($DC.Dir(mBOT\Masters.ini),Logged-As,%Do-Nick)
    if (%Do-Nick == %Owner-DC.mBOT) || ($Cown-Check(%Do-Nick)) || (%LL == Yes) || (%LX != $null) {
      if (!%Trigger) { set %Trigger ! }
      if ($1 == %Trigger $+ bot) && (%DC-mBOT-BotOff-Cmd == ON) && ($nick == %Owner-DC.mBOT || $Cown-Check(%Do-Nick))  {
        if ($2 == ON) { set %mBOT ON | notice $nick 1Now DC-mBOT is Enabled. | goto end }
        if ($2 == OFF) { set %mBOT OFF | notice $nick 1 Now DC-mBOT is Disabled. | goto end }
        else { notice $nick 1Just ON Or OFF allowed! | goto end }
      }
      if (%mBOT == OFF) goto end
      if ($1 == %Trigger $+ novoice || $1 == %Trigger $+ nv) {
        if ($2 == list) { NoVoice.List $nick | goto end }
        if ($2 == add) && ($3) {
          if ($istok(%NoVoices,$3,32)) { notice $nick $3 is already exists in No-voice list. | goto end }
          set %NoVoices $addtok(%NoVoices,$3,44)
          notice $nick $3 Added to No-voice list.
          goto end
        }
        if ($2 == del) && ($3) {
          if (!$istok(%NoVoices,$3,32)) { notice $nick No matches were found to remove. | goto end }
          set %NoVoices $deltok(%NoVoices,$3,44)
          notice $nick $3 Removed from No-voice list.
          goto end
        }
        else { notice $nick 2Syntax: %Trigger $+ Novoice Add/Del <Nick|Nick@#Channel> | goto end }
      }
      if ($me !isop $chan) goto jump
      if ($1 == %Trigger $+ op || $1 == %Trigger $+ o) && (%DC-mBOT-Op-Cmd == ON) { DoOperation $chan $nick +o $2- | goto end }
      if ($1 == %Trigger $+ voice || $1 == %Trigger $+ v) && (%DC-mBOT-Voice-Cmd == ON) { DoOperation $chan $nick +v $2- | goto end }
      if ($1 == %Trigger $+ deop || $1 == %Trigger $+ dop || $1 == %Trigger $+ dp) && (%DC-mBOT-DeOp-Cmd == ON) { DoOperation $chan $nick -o $2- | goto end }
      if ($1 == %Trigger $+ devoice || $1 == %Trigger $+ dv) && (%DC-mBOT-DeVoice-Cmd == ON) { DoOperation $chan $nick -v $2- | goto end }
      if ($1 == %Trigger $+ ban || $1 == %Trigger $+ b) && (%DC-mBOT-Ban-Cmd == ON) { 
        if (!$2-) goto end
        if (-u* iswm $2) {
          if ($remove($2,-u) < 30) { .notice $nick You should enter a number more than 30 seconds with your command. | goto end }
          if ($remove($2,-u) >= 30) {
            if (#* !iswm $3) { ban $2 $chan $3- | goto end }
            if (#* iswm $3) { ban $2- | goto end }
          }
        }
        else {
          if (!$2-) goto end
          if ($2 !ison $chan) { .notice $nick 2 $2 1Is Not Found In2 $chan | goto end }
          if ($2 == %Owner-DC.mBOT) && ($nick == %Owner-DC.mBOT || $Cown-Check(%Do-Nick)) { .notice $nick You're My Owner! | goto end }
          if ($2 == %Owner-DC.mBOT) { .notice $nick $2 is My Owner! | goto end }
          if ($2 == $me) { .notice $nick 1Huh? You want I do banning Myself?! Don't try! | goto end }
          mode $chan +b $address($2,%Bot-BanTypes)
          goto end
        }
      }
      if ($1 == %Trigger $+ rlastban || $1 == %Trigger $+ rlb || $1 == %Trigger $+ ubl) && (%DC-mBOT-UnBan-Cmd == ON) {
        if (%LastBan. [ $+ [ $chan ] ] != $null) { set %rlb.cmd ON | mode $chan -b %LastBan. [ $+ [ $chan ] ] | unset %LastBan. [ $+ [ $chan ] ] }
        goto end
      }
      if (!unban iswm $1 || !ub iswm $1) && (%DC-mBOT-UnBan-Cmd == ON) { 
        if (!$2) goto end
        else {
          if ($readini($DC.Dir(mBOT\BanList.ini),BanList_ $+ $chan,$2) != $null) { mode $chan -b $readini($DC.Dir(mBOT\BanList.ini),BanList_ $+ $chan,$2) }
          goto end
        }
      }
      if ($1 == %Trigger $+ kick || $1 == %Trigger $+ k) && (%DC-mBOT-Kick-Cmd == ON) { 
        if ($2 == %Owner-DC.mBOT) && ($nick == %Owner-DC.mBOT || $Cown-Check(%Do-Nick)) { .notice $nick You're My Owner! | goto end }
        if ($2 == %Owner-DC.mBOT) { .notice $nick $2 Is My Owner! | goto end }
        if ($2 == $me) { .notice $nick Huh? You want I do banning Myself?! Don't try! | goto end }
        else {
          if (!$3-) { kick $chan $2 Get Out! | goto end }
          if ($3- != $null) { kick $chan $2 $3- | goto end }
        }
      }
      if ($1 == %Trigger $+ kb) && (%DC-mBOT-Kb-Cmd == ON) { 
        if (!$2) halt
        if ($2 == %Owner-DC.mBOT || $Cown-Check(%Do-Nick)) && ($nick == %Owner-DC.mBOT) { .notice $nick You're My Owner! | goto end }
        if ($2 == %Owner-DC.mBOT || $Cown-Check(%Do-Nick)) { .notice $nick $2 Is My Owner! | goto end }
        if ($2 == $me) { .notice $nick Huh? You want I do Kick/Banning Myself?! Don't try! | goto end }
        else { mode $chan +b $address($2,%Bot-BanTypes) | kick $chan $2 $iif($3-,$3-,You're Banned!) | goto end }
      }
      if ($1 == %Trigger $+ mode || $1 == %Trigger $+ m) && (%DC-mBOT-Mode-Cmd == ON) {
        if (-u* iswm $2) {
          if ($remove($2,-u) < 30) { .notice $nick You should enter a number higher than 30secs. | goto end }
          if ($remove($2,-u) >= 30) {
            if (#* !iswm $3) { mode $chan $3- | .timer. $+ $+($rand(A,Z),$rand(100,99999)) 1 $remove($2,-u) /_SetMode $chan $3- | goto end }
            if (#* iswm $3) { mode $3 $4- | .timer. $+ $+($rand(A,Z),$rand(1000,99999)) 1 $remove($2,-u) /_SetMode $3 $4- | goto end }
          }
        }
        else {
          if (#* !iswm $2-) { mode $chan $2- | goto end }
          if (#* iswm $2-) { mode $2 $3- | goto end }
        }
      }
      if ($1 == %Trigger $+ topic) && (%DC-mBOT-Topic-Cmd == ON) {
        if (#* iswm $2) { topic $2 $3- $+  | .notice $nick $2 Topic Changed. | goto end }
        else { topic $chan $2- $+  | .notice $nick $chan Topic Changed. | goto end }
      }
      if ($1 == %Trigger $+ fsh) && (%DC-mBOT-Fsh-Cmd == ON) {
        if (!$2) {
          if (%Bot-Chan-KeyY. [ $+ [ $chan ] ] != ON) {
            set %Bot-Chan-KeyY. [ $+ [ $chan ] ] ON
            var %Bot-Chan-KeyX. [ $+ [ $chan ] ] = $rand(a,z) $+ $rand(0,9) $+ $rand(A,Z) $+ $rand(a,z) $+ $rand(0,9) $+ $rand(a,z) $+ $rand(0,Z) $+ $rand(0,9) $+ $rand(0,9) $+ $rand(A,Z)
            mode $chan +MRck %Bot-Chan-KeyX. [ $+ [ $chan ] ]
            msg $chan %FS-Active.Msg
            goto end
          }
        }
        if ($2 == OFF) {
          mode $chan -MRck %Bot-Chan-KeyX. [ $+ [ $chan ] ]
          unset %Bot-Chan-KeyX. [ $+ [ $chan ] ]
          unset %Bot-Chan-KeyY. [ $+ [ $chan ] ]
          msg $chan %FS-Deactive.Msg
          goto end
        }
      }
      if ($1 == %Trigger $+ clearbans || $1 == %Trigger $+ cb) {
        var %x = $ibl($chan,0)
        if (%x <= 5) { var %m1 = $ibl($chan,1) $ibl($chan,2) $ibl($chan,3) $ibl($chan,4) $ibl($chan,5) }
        if (%x <= 10) && (%x > 5) { var %m2 = $ibl($chan,6) $ibl($chan,7) $ibl($chan,8) $ibl($chan,9) $ibl($chan,10) }
        if (%x <= 15) && (%x > 10) { var %m3 = $ibl($chan,11) $ibl($chan,12) $ibl($chan,13) $ibl($chan,14) $ibl($chan,15) }
        if (%x <= 20) && (%x > 15) { var %m4 = $ibl($chan,16) $ibl($chan,17) $ibl($chan,18) $ibl($chan,19) $ibl($chan,20) }
        if (%m1) { mode $chan -bbbbb %m1 }
        if (%m2) { mode $chan -bbbbb %m2 }
        if (%m3) { mode $chan -bbbbb %m3 }
        if (%m4) { mode $chan -bbbbb %m4 }
      }
      if ($1 == %Trigger $+ clearexcepts || $1 == %Trigger $+ ce) {
        var %x = $iel($chan,0)
        if (%x <= 5) { var %m1 = $iel($chan,1) $iel($chan,2) $iel($chan,3) $iel($chan,4) $iel($chan,5) }
        if (%x <= 10) && (%x > 5) { var %m2 = $iel($chan,6) $iel($chan,7) $iel($chan,8) $iel($chan,9) $iel($chan,10) }
        if (%x <= 15) && (%x > 10) { var %m3 = $iel($chan,11) $iel($chan,12) $iel($chan,13) $iel($chan,14) $iel($chan,15) }
        if (%x <= 20) && (%x > 15) { var %m4 = $iel($chan,16) $iel($chan,17) $iel($chan,18) $iel($chan,19) $iel($chan,20) }
        if (%m1) { mode $chan -eeeee %m1 }
        if (%m2) { mode $chan -eeeee %m2 }
        if (%m3) { mode $chan -eeeee %m3 }
        if (%m4) { mode $chan -eeeee %m4 }
      }
      if ($1 == %Trigger $+ clearinvites || $1 == %Trigger $+ ci) {
        var %x = $iil($chan,0)
        if (%x <= 5) { var %m1 = $iil($chan,1) $iil($chan,2) $iil($chan,3) $iil($chan,4) $iil($chan,5) }
        if (%x <= 10) && (%x > 5) { var %m2 = $iil($chan,6) $iil($chan,7) $iil($chan,8) $iil($chan,9) $iil($chan,10) }
        if (%x <= 15) && (%x > 10) { var %m3 = $iil($chan,11) $iil($chan,12) $iil($chan,13) $iil($chan,14) $iil($chan,15) }
        if (%x <= 20) && (%x > 15) { var %m4 = $iil($chan,16) $iil($chan,17) $iil($chan,18) $iil($chan,19) $iil($chan,20) }
        if (%m1) { mode $chan -IIIII %m1 }
        if (%m2) { mode $chan -IIIII %m2 }
        if (%m3) { mode $chan -IIIII %m3 }
        if (%m4) { mode $chan -IIIII %m4 }
      }
      if ($1 == %Trigger $+ trigger || $1 == %Trigger $+ tr) { 
        var %trig = ! @ ^& # . , - + `
        if (!$2) { notice $nick 1The Trigger is (4 %Trigger 1) | goto end }
        if ($2 == List) { notice $nick 1Triggers List: (4 %trig 1) | goto end }
        if (!$istok(%trig,$2,32)) { notice $nick 1Just (4 %trig1) are supported. | goto end }
        if ($2 == %Trigger) { notice $nick 1The Trigger already is (4 $2 1) | goto end }
        else { var %nt = $gettok(%trig,$findtok(%trig,$2,1,32),32) | set %Trigger %nt | notice $nick 1The Trigger is now changed to (4 %nt 1) }
      }
      if ($1 == %Trigger $+ invite || $1 == %Trigger $+ inv) && (%DC-mBOT-Invite-Cmd == ON) {
        if (!$2) { .notice $nick You must enter a Nickname! | goto end }
        else {
          if (!$3) { invite $2 $chan | .notice $nick 2 $+ $2 1has been invited to2 $chan | goto end }
          else { invite $2 $3 | .notice $nick 2 $+ $2 1has been invited to2 $3 | goto end }
        }
      }
      :jump
      if ($1 == %Trigger $+ say) && (%DC-mBOT-Say-Cmd == ON) {
        if (*#* iswm $2) && ($me ison $2) { msg $2 $3- | goto end }
        else { msg $chan $2- | goto end }
      }
      if ($1 == %Trigger $+ act) && (%DC-mBOT-Act-Cmd == ON) {
        if (*#* iswm $2) { describe $2 $3- | goto end }
        else { describe $chan $2- | goto end }
      }
      if ($1 == %Trigger $+ help) && (%DC-mBOT-Help-Cmd == ON) {
        if (!$2) { .play $nick $DC.Dir(Doc\Cmd.txt) | goto end }
        if ($2 != $null) {
          if ($2 == set) { .play $nick $DC.Dir(Doc\Set-Help.txt) }
          if ($2 == mode) { .play $nick $DC.Dir(Doc\Mode-Help.txt) }
          if ($2 == extra) { notice $nick 1Type ''2 $+ %Trigger $+ Extra 1[2IP|Ping|Weather|Avoice|Adevoice|Seen|Find|BTalk1] 1[2ON|OFF1]'' }
        }
      }
      if ($1 == %Trigger $+ btype || $1 == %Trigger $+ bt) && (%DC-mBOT-BanType-Cmd == ON) {
        if (!$2 || $2 !isnum 0-9) && ($2 != 0) { .notice $nick 1You must enter a 'Digit Number' between4 0-9 | goto end }
        if ($2 == %Bot-BanTypes) { .notice $nick 1The Bantype already is2 $2 $+  | goto end }
        else {
          var %types = *!User@Host *!*User@Host *!*@Host *!*User@*.Host *!*@*.Host Nick!User@Host Nick!*User@Host Nick!*@Host Nick!*User@*.Host Nick!*@*.Host
          set %Bot-BanTypes $2
          notice $nick 1Protections Bantype was changed to2 $2 1and it Means:2 $gettok(%types,$calc($2 + 1),32)
        }
        goto end
      }
      if ($1 == %Trigger $+ extra) && (%DC-mBOT-Extra-Cmd == ON) {
        if (!$2) goto ExtHint
        else {
          if ($2 == ON || $2 == OFF) { set %Extra-Set $2 | notice $nick 1Extra Settings is now turned $+(,$upper($2),,.) | goto end }
          var %extras = ip top10 ping weather avoice adevoice seen btalk limiter
          if (!$istok(%extras,$2,32)) goto ExtHint
          else {
            if (!$3) || ($3 != ON && $3 != OFF) goto ExtHint
            var %extvars = IP-Loc-Cmd Top10 Pingg Weather-Cmd Auto-Voice Auto-Devoice DC-Seen DC-mBOT-Talking-Cmd Limiter
            var %extnames = IP Locator,Top10,Ping Replyer,Weather,Auto Voicer,Auto Devoicer,Seen System,Bot Talk,Channel Limiter
            var %token = $findtok(%extras,$2,1,32)
            set % $+ $gettok(%extvars,%token,32) $3
            if ($2 == ping) { $iif($3 == ON,.enable,.disable) #Pinger }
            if ($2 == seen) { .writeini $DC.Dir(mBOT\xSeen.ini) settings status 1 }
            notice $nick 1The $+(,$gettok(%extnames,%token,44),) is now turned $+(,$upper($3),,.)
            goto end
          }
          :ExtHint
          notice $nick 1Please enter '2 $+ %Trigger $+ Extra 1[2IP|Ping|Weather|Avoice|Adevoice|Seen|BTalk|Limiter1] 1[2ON|OFF1]'
          goto end
        }
      }
      if ($1 == %Trigger $+ pro) && (%DC-mBOT-Pro-Cmd == ON) {
        if (!$2) || ($2 != set && $2 != mode) goto ProHint
        else {
          if ($2 == ON) || ($2 == OFF) { $iif($2 == ON,.enable,.disable) #Bot-Pro | notice $nick 1Bot's Protections $iif($2 == ON,Activated.,Deactivated.) | goto end }
          if ($2 == set) {
            if (!$3 || !$4) goto ProHint
            var %pros = badword badnick adv repeat bigmsg joinpart flood joinflood nickflood fs clone dontkbops dontkbvoices sendres antiban antideop
            if (!$istok(%pros,$3,32)) goto ProHint
            else {
              var %provars = Badwords BadNicks Adv Repeat BigMsg JoinPart Flood JoinFlood NickFlood FS Clones Dont-Kb-Op Dont-Kb-Voice Send-Notice-BNick NoOne-Ban NoOne-Deop
              var %pronames = Badword,Bad Nick,Advertise,Repeat,Big Message, Join/Part,Flood,Join Flood,Nick Flood,FS,Clone,Don't Kick/Ban Ops,Don't Kick/Ban Voices,Send the Ban Reason,Anti Ban,Anti Deop
              var %token = $findtok(%pros,$3,1,32)
              set % $+ $gettok(%provars,%token,32) $4
              notice $nick 1The $+(,$gettok(%pronames,%token,44),) Protections is now turned $+(,$upper($4),,.)
              goto end
            }
            :ProHint
            notice $nick 1Please enter '2 $+ %Trigger $+ Pro set 1[2Badword|Badnick|Adv|Repeat|Bigmsg|Joinpart|Flood|Joinflood|Nickflood|Fs|Clone|Dontkbops|Dontkbvoices|Sendres|Antiban|Antideop1] 1[2ON|OFF1]'
            goto end
          }
          if ($2 == mode) {
            if (!$3 || !$4) goto ProHintm
            var %prosm = repeat joinpart flood clone ctcp changenick joinflood nickflood
            if (!$istok(%prosm,$3,32)) goto ProHintm
            else {
              var %promvars = Repeat.AutoModes JoinPart.AutoModes Flood.AutoModes Clones.AutoModes CTCP.AutoModes Change-Nick.AutoModes Join-Flood.AutoModes NickFlood.AutoModes
              var %promnames = Repeat,Join/Part,Flood,Clone,CTCP,Change Nick,Join Flood,Nick Flood
              var %token = $findtok(%prosm,$3,1,32)
              set % $+ $gettok(%promvars,%token,32) $4
              notice $nick 1The $+(,$gettok(%pronames,%token,44),) Auto Mode Protections is now turned $+(,$upper($4),,.)
              goto end
            }
            :ProHintm
            notice $nick 1Please enter '2 $+ %Trigger $+ Pro mode 1[2Repeat|Joinpart|Flood|Clone|Ctcp|Changenick|Joinflood|Nickflood1] 1[2ON|OFF1]'
            goto end
          }
        }
      }
    }
    if (%Do-Nick == %Owner-DC.mBOT || $Cown-Check(%Do-Nick)) {
      if ($1 == %Trigger $+ rejoin || $1 == %Trigger $+ rej) && (%DC-mBOT-Join-Cmd == ON) {
        if (!$2) { set %Re.Chan $chan | part %Re.Chan | .timer.rej 1 1 /join %Re.Chan | .timer.rejj 1 1 /notice $nick 1I did rejoined to2 %Re.Chan | unset %Re.Chan | goto end }
        else {
          if ($me !ison $2) && ($2 != all) { .notice $nick 1I'm Not On2 $2 | goto end }
          if ($2 == all) {
            if ($chan(0) > 0) && ($scon(0) < 2) {
              var %a = 1
              while (%a <= $chan(0)) { var %ch = $addtok(%ch,$chan(%a),44) | inc %a }
              .partall 2Rejoining to all channels
              .timer.reja 1 1 /join %ch
            }
          }
          else { set -u5 %Re.Chan $2 | part %Re.Chan 2Rejoining to4 %Re.Chan $+  | .timer.rej 1 1 /join %Re.Chan }
          goto end
        }
      }
      if ($1 == %Trigger $+ join || $1 == %Trigger $+ j) && (%DC-mBOT-Join-Cmd == ON) {
        if ($left($2,1) == $chr(35)) {
          if ($me ison $2) { .notice $nick 1I'm already on there.2 $2 | goto end }
          else { join $2 | notice $nick 1I'm joined to2 $2 | goto end }
        }
        else { notice $nick 2Syntax: %Trigger $+ Join #DCScript | goto end }
      }
      if ($1 == %Trigger $+ nick) && (%DC-mBOT-Nick-Cmd == ON) {
        if (!$2) { notice $nick I couldn't changed my Nick! Please Enter a Nickname in '' $+ %Trigger $+ Nick'' command. | goto end }
        else { nick $2 | goto end }
      }
      if ($1 == %Trigger $+ identify || $1 == %Trigger $+ id) && (%DC-mBOT-Identify-Cmd == ON) && ($2) { NickServ Identify $2- | .notice $nick 1I'm Now Identified On NickServ. | goto end }
      if ($1 == %Trigger $+ part || $1 == %Trigger $+ p) && ($nick == %Owner-DC.mBOT || $Cown-Check(%Do-Nick)) && (%DC-mBOT-Part-Cmd == ON) {
        if ($2 == $null) {
          if ($me ison $chan) { part $chan 1DC-mBOT has been parts from2 $chan 1[DC] | .notice $nick 1Now I'm not on $chan | goto end }
          else { .notice $nick 1I'm not on there.2 $chan | goto end }
        }
        if ($2 != $null) {
          if ($2 == All) { partall | notice $nick 1 $+ $me Parts from all channels. | goto end }
          if ($me ison $2) { part $2 1DC-mBOT has been parts from2 $chan 1[DC | notice $nick 1Now I'm not on $2 | goto end }
          else { notice $nick 1I'm not on there.2 $2 | goto end }
        }
      }
      if ($1 == %Trigger $+ quit) && (%DC-mBOT-Quit-Cmd == ON) { 
        if ($2- != $null) {
          notice $nick 1I'm Quiting From2 $server
          quit $2-
        }
        if ($2- == $null) {
          notice $nick 1I'm Quiting From2 $server
          quit $DC.Quit
          goto end
        }
      }
      if ($1 == %Trigger $+ amaster) && (%DC-mBOT-Admaster-Cmd == ON) {
        if ($2 == $null) { notice $nick 1You should enter a Nickname with %Trigger $+ amster to add a Master. | goto end }
        if ($2 != $null) {
          if ($readini($DC.Dir(mBOT\Masters.ini), Master_ $+ $2, Pass) != $null) { notice $nick $+(4,$2,1 was already a Master!) | goto end }
          set %Bot-Master-Add. [ $+ [ $2 ] ] $2
          msg %Bot-Master-Add. [ $+ [ $2 ] ] %Bot-Master-Add. [ $+ [ $nick ] ] Welcome to my Master list.
          msg %Bot-Master-Add. [ $+ [ $2 ] ] To set your Password type2 /msg $me Setpass YourPassword
          goto end
        }
      }
      if ($1 == %Trigger $+ dmaster) && (%DC-mBOT-Admaster-Cmd == ON) {
        if ($2 == $null) { notice $nick 1You should enter a Nickname with %Trigger $+ dmaster to remove masters. | goto end }
        if ($2 != $null) {
          if ($readini($DC.Dir(mBOT\Masters.ini), Master_ $+ $2, Pass) == $null) { notice $nick $+(4,$2,1 wasn't a Master!) | goto end }
          set %Bot-Master-Del $2
          Master-Del
          goto end
        }
      }
    }
  }
  :end
  unset %Do-Nick
  unset %BantypeX
  unset %TBT
  unset %LL
  unset %LX
}

on *:Text:*:?:{
  if ($1 == say) {
    if ($nick != %Owner-DC.mBOT) && (!$Cown-Check($nick)) { notice $nick You cannot use that command! Only Owner or Co-Owner may use that. | goto end }
    if ($nick == %Owner-DC.mBOT) && ($Cown-Check($nick)) {
      if ($2 == $null) { notice $nick You Must Enter A Channel Name! (Syntax: /msg $me say #Channel Messege) | goto end }
      if ($3- == $null) { notice $nick What I Say On That Channel? Enter A Message Here. (Syntax: /msg $me say #Channel Messege) | goto end }
      if ($2 != $null && $3- != $null) {
        if ($me !ison $2) { notice msg $nick I'm Not In3 $2  | goto end }
        if ($left($2,1) == $chr(35)) && ($me ison $2) { msg $2 $3- | goto end }
      }
      else { notice $nick What I Say On That Channel? Enter A Message Here. (Syntax: /msg $me say #Channel Messege) | goto end }
    }
  }
  elseif ($1 == act) {
    if ($nick != %Owner-DC.mBOT) && (!$Cown-Check($nick)) { notice $nick You cannot use that command! Only Owner or Co-Owner may use that. | goto end }
    if ($nick == %Owner-DC.mBOT) || ($Cown-Check($nick)) {
      if ($2 == $null) { notice $nick You Must Enter A Channel Name! (Syntax: /msg $me say #Channel Messege) | goto end }
      if ($3- == $null) { notice $nick What I Say On That Channel? Enter A Message Here. (Syntax: /msg $me say #Channel Messege) | goto end }
      if ($2 != $null && $3- != $null) {
        if ($me !ison $2) { notice $nick I'm Not In3 $2  | goto end }
        if ($left($2,1) == $chr(35)) && ($me ison $2) { describe $2 $3- | goto end }
      }
      else { notice $nick What I say on that channel? Enter a message after your command. (Syntax: /msg $me say #Channel Messege) | goto end }
    }
  }
  elseif ($1 == setpass) {
    set %TmpPass $2-
    if ($len(%TmpPass) < 6) {
      msg $nick You should enter a password more than 6 characters!
      unset %TmpPass
      goto end
    }
    Master-Add $nick
    goto end
  }
  elseif ($1 == login) {
    if ($2 == $null) || ($3- == $null) {
      if (%Wrong.Ignore. [ $+ [ $nick ] ] == $null) { msg %TheNick Your command was Invalid! Try by a valid command. Be careful, You'll be ignored after  $+ %DC-mBOT-UIgnore.Times $+   wrong Commands! | set -u3600 %Wrong.Ignore. [ $+ [ $nick ] ] 1 | goto end }
      else { inc %Wrong.Ignore. [ $+ [ $nick ] ] }
      if (%Wrong.Ignore. [ $+ [ $nick ] ] == $calc(%DC-mBOT-UIgnore.Times - 1)) {
        if (%DC-mBOT-UIgnore.Times == 2) goto Jump3
        else { msg %TheNick Your Cmd Is Not Valid! Only 1 More Cmd Remaining! }
      }
      :Jump3
      if (%Wrong.Ignore. [ $+ [ $nick ] ] >= %DC-mBOT-UIgnore.Times) { msg %TheNick You have been ignored by Me! | set %Go.Ignore. [ $+ [ $nick ] ] Go | Wrong.Cmds.Ignore }
      goto end
    }
    else {
      set -u6 %TheNick $nick
      set %TmpNick $2
      set %TmpPass $3-
      Master-Login
      goto end
    }
  }
  elseif ($1 == getpass) {
    if ($2 == $null) || ($3 == $null) {
      msg $nick You Must Enter /msg $me Getpass Nick SecurityCode
      if (%Wrong.Ignore. [ $+ [ $nick ] ] == $null) { msg %TheNick Your command was Invalid! Try by a valid command. Be careful, You'll be ignored after  $+ %DC-mBOT-UIgnore.Times $+   wrong Commands! | set -u3600 %Wrong.Ignore. [ $+ [ $nick ] ] 1 | goto end }
      else { inc %Wrong.Ignore. [ $+ [ $nick ] ] }
      if (%Wrong.Ignore. [ $+ [ $nick ] ] == $calc(%DC-mBOT-UIgnore.Times - 1)) {
        if (%DC-mBOT-UIgnore.Times == 2) goto Jump2
        else { msg %TheNick Your Cmd Is Not Valid! Only 1 More Cmd Remaining! }
      }
      :Jump2
      if (%Wrong.Ignore. [ $+ [ $nick ] ] >= %DC-mBOT-UIgnore.Times) { msg %TheNick You have been ignored by Me! | set %Go.Ignore. [ $+ [ $nick ] ] Go | Wrong.Cmds.Ignore }
      goto end
    }
    else {
      set -u6 %TheNick $nick
      set %TmpNick $2
      set %TmpCode $3
      Master-GetPass
      goto end
    }
  }
  elseif ($1 == cpass) {
    if ($2 == $null) || ($3 == $null) || ($4 == $null) {
      msg $nick You Must Enter /msg $me CPass OldPass NewPass
      if (%Wrong.Ignore. [ $+ [ $nick ] ] == $null) { msg %TheNick Your command was Invalid! Try by a valid command. Be careful, You'll be ignored after  $+ %DC-mBOT-UIgnore.Times $+   wrong Commands! | set -u3600 %Wrong.Ignore. [ $+ [ $nick ] ] 1 | goto end }
      else { inc %Wrong.Ignore. [ $+ [ $nick ] ] }
      if (%Wrong.Ignore. [ $+ [ $nick ] ] == $calc(%DC-mBOT-UIgnore.Times - 1)) {
        if (%DC-mBOT-UIgnore.Times == 2) goto Jump1
        else { msg %TheNick Your command was Invalid! only 1 more command remained! }
      }
      :Jump1
      if (%Wrong.Ignore. [ $+ [ $nick ] ] >= %DC-mBOT-UIgnore.Times) { msg %TheNick You have been ignored by Me! | set %Go.Ignore. [ $+ [ $nick ] ] Go | Wrong.Cmds.Ignore }
      goto end
    }
    else {
      set -u6 %TheNick $nick
      set %TmpNick $2
      set %TmpPass $3
      set %NTmpPass $4
      Change-Pass
      goto end
    }
  }
  elseif ($1 == logout) {
    if ($2) && ($3) {
      set -u6 %TheNick $nick
      set %TmpNick $2
      set %TmpPass $3
      Logout-Master
      goto end
    }
  }
  elseif ($1 == Sendcode) {
    if ($2 == $null) || ($3 == $null) {
      msg $nick You Must Enter /msg $me Sendcode Nick Password
      if (%Wrong.Ignore. [ $+ [ $nick ] ] == $null) { msg %TheNick Your command was Invalid! Try by a valid command. Be careful, You'll be ignored after  $+ %DC-mBOT-UIgnore.Times $+   wrong Commands! | set -u3600 %Wrong.Ignore. [ $+ [ $nick ] ] 1 | goto end }
      else { inc %Wrong.Ignore. [ $+ [ $nick ] ] }
      if (%Wrong.Ignore. [ $+ [ $nick ] ] == $calc(%DC-mBOT-UIgnore.Times - 1)) {
        if (%DC-mBOT-UIgnore.Times == 2) goto Jump5
        else { msg %TheNick Your command was Invalid! only 1 more command remained! }
      }
      :Jump5
      if (%Wrong.Ignore. [ $+ [ $nick ] ] >= %DC-mBOT-UIgnore.Times) { msg %TheNick You have been ignored by Me! | set %Go.Ignore. [ $+ [ $nick ] ] Go | Wrong.Cmds.Ignore }
      goto end
    }
    else {
      set -u6 %TheNick $nick
      set %TmpNick $2
      set %TmpPass $3
      Send-Code
      goto end
    }
  }
  elseif ($1 == help) {
    if ($2 == $null) { .play $nick $DC.Dir(Doc\Cmd.txt) | goto end }
    if ($2 != $null) {
      if ($2 == set) { .play $nick $DC.Dir(Doc\Set-Help.txt) | goto end }
      if ($2 == mode) { .play $nick $DC.Dir(Doc\Mode-Help.txt) | goto end }
      if ($2 == extra) { notice $nick Type: ''2 $+ %Trigger $+ Extra [IP/Ping/Weather/Avoice/Seen/Find/BTalk1] [ON/OFF]'' | goto end }
    }
  }
  elseif ($1 == cmds) {
    set -u6 %TheNick $nick
    msg %TheNick To Login your access type:2 /msg $me Login Nick Password
    msg %TheNick To see your Security Code type:2 /msg $me Sendcode Nick Password
    msg %TheNick If you Forgot your Password to get it type:2 /msg $me Getpass Nick SecurityCode
    msg %TheNick For Change your Password type:2 /msg $me CPass OldPass NewPass
    msg %TheNick To LogOut your access type:2 /msg $me Logout Nick Password
    unset %TheNick
    goto end
  }
  elseif ($1 == trigger) {
    set -u6 %TheNick $nick
    msg %TheNick The Trigger Is:4 %Trigger
    unset %TheNick
    goto end
  }
  else { Log.Writing $nick $1- }
  :end
  close -m $nick
  halt
}
#DC-mBOT End

alias -l Log.Writing {
  if ($1) {
    if ($window(@Log. $+ $network,state) == 0) {
      window -B @Log. $+ $network
      echo @Log. $+ $network 2Time/Date:1 $fulldate
      echo @Log. $+ $network 4 ---------------------------------------------
    }
    echo @Log. $+ $network 2Nick:1 $1
    echo @Log. $+ $network 2Time/Date:1 $fulldate
    echo @Log. $+ $network 2Message(s):1 $2-
    echo @Log. $+ $network 2 ---------------------------------------------
  }
}

alias CheckMasters {
  var %c = 0
  while (%c <= $lines($DC.Dir(mBOT\Masters.ini))) {
    if (*Master_* iswm $read($DC.Dir(mBOT\Masters.ini),%c)) { var %y = $right($left(%x,-1),-8) | .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,%y) Login No }
    inc %c
  }
}

alias -l Master-Login {
  set %TP $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %TmpNick,Pass)
  set %TL $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %TmpNick,Login)
  if (%TP != %TmpPass) {
    msg %TheNick The Password Is4 Incorrect!
    if (%Wrong.Ignore. [ $+ [ $nick ] ] == $null) { msg %TheNick Your command was Invalid! Try by a valid command. Be careful, You'll be ignored after  $+ %DC-mBOT-UIgnore.Times $+   wrong Commands! | set -u3600 %Wrong.Ignore. [ $+ [ $nick ] ] 1 | goto end }
    else { inc %Wrong.Ignore. [ $+ [ $nick ] ] }
    if (%Wrong.Ignore. [ $+ [ $nick ] ] == $calc(%DC-mBOT-UIgnore.Times - 1)) {
      if (%DC-mBOT-UIgnore.Times == 2) goto Jump
      else { msg %TheNick Your command was Invalid! only 1 more command remained! }
    }
    :Jump
    if (%Wrong.Ignore. [ $+ [ $nick ] ] >= %DC-mBOT-UIgnore.Times) { msg %TheNick You have been ignored by Me! | set %Go.Ignore. [ $+ [ $nick ] ] Go | Wrong.Cmds.Ignore }
    goto end
  }
  if (%TP == %TmpPass) {
    if (%TL == Yes) { msg %TheNick You're Already Identified On Me. | unset %TmpNick | goto end }
    else {
      if (%TmpNick == %TheNick) { 
        .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,%TmpNick) Login Yes
        msg %TheNick Welcome Dear, You're Identified On Me.
        unset %TmpNick %TmpPass
        unset %TP %TL
        halt
      }
      if (%TmpNick != %TheNick) { 
        .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,%TmpNick) Login Yes
        .writeini $DC.Dir(mBOT\Masters.ini) Logged-As %TheNick %TmpNick
        msg %TheNick Welcome Dear, You're Logged As3 %TmpNick $+ .
        unset %TmpNick %TmpPass
        unset %TP %TL
        halt
      }
    }
  }
  :end
  unset %TP %TL %TmpNick %TmpPass %TheNick
}
alias -l Master-GetPass {
  set %GP $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %TmpNick,Pass)
  set %TC $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %TmpNick,Code)
  if (%TC != %TmpCode) { msg %TmpNick The Security Code Is4 Incorrect! | goto end }
  if (%TC == %TmpCode) {
    msg %TheNick Your Password Is:2 %GP
    msg %TheNick If You Want To Change Your Password Type:2 /msg $me CPass Nick OldPass NewPass
    unset %TmpPass %TmpNick
    unset %GP %TC
    halt
  }
  :end
  unset %GP %TC %TmpPass %TmpNick
}
alias -l Change-Pass {
  set %OTmpPass $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %TmpNick,Pass)
  if (%OTmpPass == $null) { msg %TmpNick There Are No Access For %TmpNick | goto end }
  if (%OTmpPass != %TmpPass) { msg %TmpNick The Password Is4 Incorrect! | goto end }
  if (%OTmpPass == %TmpPass) {
    .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,%TmpNick) Pass %NTmpPass
    msg %TheNick Change Password Successfully Completed.
    msg %TheNick Your New Password Is:2 %NTmpPass
    unset %TmpPass %TmpNick %TheNick
    unset %f %NTmpPass %OTmpPass
    halt
  }
  :end
}
alias -l Send-Code {
  set %GP $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %TmpNick,Pass)
  set %TC $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %TmpNick,Code)
  if (%GP != %TmpPass) { msg %TmpNick The Security Code Is4 Incorrect! | goto end }
  if (%GP == %TmpPass) { msg %TheNick Your Security Code Is:2 %TC | goto end }
  :end
  unset %GP %TC %TmpPass %TmpNick %TheNick
}
alias Logout-Master { 
  var %x = $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %TmpNick,Pass)
  if (!%x) { msg %TmpNick There is No Access For %TmpNick }
  elseif (%x != %TmpPass) { msg %TmpNick The Password Is4 Incorrect! }
  elseif (%x == %TmpPass) { .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,%TmpNick) Login No | msg %TheNick Access Logout, Ciao. }
  unset %TmpPass %TmpNick %XTmpPass %TheNick
}
alias -l Master-Add {
  if ($1 == $null) && (%Bot-Master-Add. [ $+ [ $nick ] ] == $null) halt
  var %TmpCode = $rand(A,Z) $+ $rand(0,9) $+ $rand(A,Z) $+ $rand(a,z) $+ $rand(0,9) $+ $rand(A,Z)
  .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,$1) Pass %TmpPass
  .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,$1) Code %TmpCode
  if (%DialogAdd == ON) { .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,$1) Login No | goto jump }
  .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,$1) Login Yes
  msg $1 Now You Added To My Master List.
  msg $1 To Login Type2 /msg $me Login %Bot-Master-Add %TmpPass
  msg $1 Your Security Code Is:2 %TmpCode
  msg $1 Don't forgot your Security Code! It's for Password recovery and/or when you want to remove yourself from Master list!
  msg $1 To Help about the commands type2 %Trigger $+ Help Or2 /msg $me Help
  msg $1 For Query commands such as 'Login, Getpass, ...' Type:2 /msg $me Cmds
  :Jump
  unset %TmpPass %TmpCode %Bot-Master-Add. [ $+ [ $nick ] ]
  if ($dialog(DC-mBOT)) { did -r DC-mBOT 24,104 | mBOT-Master-List }
}
alias -l Master-Del {
  if (%Bot-Master-Del == $null) halt
  var %Botmd = $readini($DC.Dir(mBOT\Masters.ini),Master_ $+ %Bot-Master-Del,Login)
  if (%Botmd == $null) { notice %Owner-DC.mBOT 4 Wrong Nickname:1 There is no Master with that Nickname on my Database! | unset %Botmd | unset %Bot-Master-Del | halt }
  .remini $DC.Dir(mBOT\Masters.ini) $+(Master_,%Bot-Master-Del)
  if (%DialogAdd == ON) goto Jump
  notice %Owner-DC.mBOT 1 %Bot-Master-Del Removed from my Master list.
  if (%Bot-Master-Del ison $chan) { msg %Bot-Master-Del %Bot-Master-Del $+ : You have been removed from my Master list. }
  :Jump
  unset %Bot-Master-Del
  if ($dialog(DC-mBOT)) { mBOT-Master-List }
}

on *:Ban:#:{
  if ($bnick != $me) { set %LastBan. [ $+ [ $chan ] ] $banmask }
  if (%FS == ON) && ($bnick != $me) {
    if (%GoActive. [ $+ [ $chan ] ] == Go) halt
    if (%BanNumber. [ $+ [ $chan ] ] == $null) { set -u [ $+ [ %FS-Time ] ] %BanNumber. [ $+ [ $chan ] ] 1 }
    else { inc %BanNumber. [ $+ [ $chan ] ] }
    if (%BanNumber. [ $+ [ $chan ] ] >= %FS-Bans) { unset %BanNumber. [ $+ [ $chan ] ] | set -u10 %GoActive. [ $+ [ $chan ] ] Go | FloodStyleGo }
  }
}
on 1:Quit:{
  if ($nick != $me) {
    if ($readini($DC.Dir(mBOT\Masters.ini),Master_ $+ $nick,Login) == Yes) { .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,$nick) Login No }
    if ($readini($DC.Dir(mBOT\Masters.ini),Logged-As,$nick)) { .remini $DC.Dir(mBOT\Masters.ini) Logged-As $nick }
    if (%XL !ison $chan) { .writeini $DC.Dir(mBOT\Masters.ini) $+(Master_,%XL) Login No }
  }
}

alias Say-Chan-Stats {
  if (#*  !iswm %Go.Stats.Chan) { notice %Do-Nick 1Syntax:3 %Trigger $+ ChanStat #Test 1OR3 %Trigger $+ ChanStat1 for active channel! | unset %Go.Stats.Cha* | return }
  if ($me !ison %Go.Stats.Chan) { notice %Do-Nick 1I'm not on3 %Go.Stats.Chan | unset %Go.Stats.Cha* | return }
  if ($me !ison %Go.Stats.Chans) { notice %Do-Nick 1I'm not on3 %Go.Stats.Chans | unset %Go.Stats.Cha* | return }
  else {
    var %Stats.Op $opnick(%Go.Stats.Chans,0)
    var %Stats.Voice $vnick(%Go.Stats.Chans,0)
    var %Stats.Hop $hnick(%Go.Stats.Chans,0)
    var %Stats.Normal $calc($nick(%Go.Stats.Chans,0) - ($opnick(%Go.Stats.Chans,0) + $vnick(%Go.Stats.Chans,0) + $hnick(%Go.Stats.Chans,0)))
    var %Stats.Total $nick(%Go.Stats.Chans,0)
    var %Stats.Op.P $round($calc(100 * ($opnick(%Go.Stats.Chans,0)) / $nick(%Go.Stats.Chans,0)),2) $+ $chr(37)
    var %Stats.Hop.P $round($calc(100 * ($hnick(%Go.Stats.Chans,0)) / $nick(%Go.Stats.Chans,0)),2) $+ $chr(37)
    var %Stats.Voice.P $round($calc(100 * ($vnick(%Go.Stats.Chans,0)) / $nick(%Go.Stats.Chans,0)),2) $+ $chr(37)
    set %Stats.Normal.P $round($calc(100 * ($nick(%Go.Stats.Chans,0) - $opnick(%Go.Stats.Chans,0) - $vnick(%Go.Stats.Chans,0)) / $nick(%Go.Stats.Chans,0)),2) $+ $chr(37)
    msg %Go.Stats.Chan 3[ $+ %Go.Stats.Chans Stats]2 Ops:4 %Stats.Op ( $+ %Stats.Op.P $+ )2 - Hops:4 %Stats.Hop ( $+ %Stats.Hop.P $+ )2 - Voices:4 %Stats.Voice ( $+ %Stats.Voice.P $+ )2 - Normal:4 %Stats.Normal ( $+ %Stats.Normal.P $+ )2 - Total:4 %Stats.Total
    unset %Stats.* %Go.Stats.Cha*
  }
}
alias -l Wrong.Cmds.Ignore {
  if (%DC-mBOT-UIgnore-Cmd == ON) && (%DC-mBOT-UIgnore.Times != $null && %DC-mBOT-UIgnore.Ban != $null) {
    if (%Go.Ignore. [ $+ [ $nick ] ] == Go) && (%Wrong.Ignore. [ $+ [ $nick ] ] != $null) { ignore -pntcdu [ $+ [ $calc(%DC-mBOT-UIgnore.Ban * 60) ] ] $nick 2 }
  }
  unset %Go.Ignore. [ $+ [ $nick ] ]
  unset %Wrong.Ignore. [ $+ [ $nick ] ]
}
on *:Invite:#:{
  if ($nick == %Owner-DC.mBOT) || ($Cown-Check($nick)) { join $chan }
}
on 1:Notice:*:*:{
  if (%Notice.Cmds == ON) && ($1 == %Notice.Pass) {
    if ($2 == say) || ($2 == me) { .notice $nick Please use (/msg #Channel MSG) for Say and use (/describe #Channel MSG) for Action message. }
    else { $2- }
  }
}

alias DoOperation {
  var %x = $iif($remove($iif($4-,$strip($4-,burc),$nick),@,+,%,~,!,:,$chr(44),$chr(46)) != $null,$ifmatch,$2)
  var %y = $numtok(%x,32)
  var %cmd = $remove($+($iif($3 == +o,isop),$iif($3 == -o,!isop),$iif($3 == +v,isvoice),$iif($3 == -v,!isvoice)),$chr(32))
  while (%y) {
    if ($gettok(%x,%y,32) %cmd $1) || ($gettok(%x,%y,32) !ison $1) {
      if ($numtok(%x,32) == 1) return
      %x = $remtok(%x,$gettok(%x,%y,32),1,32)
    }
    dec %y
  }
  if ($numtok(%x,32) > 0) { mode $1 $+($str($3,$numtok(%x,32))) %x }
}
